/*
 * This an unstable interface of wlroots. No guarantees are made regarding the
 * future consistency of this API.
 */
#ifndef WLR_USE_UNSTABLE
#error "Add -DWLR_USE_UNSTABLE to enable unstable wlroots features"
#endif

#ifndef WLR_TYPES_WLR_TEXT_INPUT_V3_H
#define WLR_TYPES_WLR_TEXT_INPUT_V3_H

#include <wayland-server.h>
#include <wlr/types/wlr_seat.h>
#include <wlr/types/wlr_surface.h>

struct wlr_text_input_v3_state {
	struct {
		char *text; // NULL is allowed and equivalent to empty string
		uint32_t cursor;
		uint32_t anchor;
	} surrounding;

	uint32_t text_change_cause;

	struct {
		uint32_t hint;
		uint32_t purpose;
	} content_type;

	struct {
		int32_t x;
		int32_t y;
		int32_t width;
		int32_t height;
	} cursor_rectangle;
};

struct wlr_text_input_v3 {
	struct wlr_seat *seat; // becomes null when seat destroyed
	struct wl_resource *resource;
	struct wlr_surface *focused_surface;
	struct wlr_text_input_v3_state pending;
	struct wlr_text_input_v3_state current;
	uint32_t current_serial; // next in line to send
	bool pending_enabled;
	bool current_enabled;

	struct wl_list link;

	struct wl_listener surface_destroy;
	struct wl_listener seat_destroy;

	struct {
		struct wl_signal enable; // (struct wlr_text_input_v3*)
		struct wl_signal commit; // (struct wlr_text_input_v3*)
		struct wl_signal disable; // (struct wlr_text_input_v3*)
		struct wl_signal destroy; // (struct wlr_text_input_v3*)
	} events;
};

struct wlr_text_input_manager_v3 {
	struct wl_global *global;

	struct wl_list bound_resources; // struct wl_resource*::link
	struct wl_list text_inputs; // struct wlr_text_input_v3::resource::link

	struct wl_listener display_destroy;

	struct {
		struct wl_signal text_input; // (struct wlr_text_input_v3*)
		struct wl_signal destroy; // (struct wlr_input_method_manager_v3*)
	} events;
};

struct wlr_text_input_manager_v3 *wlr_text_input_manager_v3_create(
	struct wl_display *wl_display);
void wlr_text_input_manager_v3_destroy(
	struct wlr_text_input_manager_v3 *manager);

// Sends enter to the surface and saves it
void wlr_text_input_v3_send_enter(struct wlr_text_input_v3 *text_input,
	struct wlr_surface *wlr_surface);
// Sends leave to the currently focused surface and clears it
void wlr_text_input_v3_send_leave(struct wlr_text_input_v3 *text_input);
void wlr_text_input_v3_send_preedit_string(struct wlr_text_input_v3 *text_input,
	const char *text, uint32_t cursor_begin, uint32_t cursor_end);
void wlr_text_input_v3_send_commit_string(struct wlr_text_input_v3 *text_input,
	const char *text);
void wlr_text_input_v3_send_delete_surrounding_text(
	struct wlr_text_input_v3 *text_input, uint32_t before_length,
	uint32_t after_length);
void wlr_text_input_v3_send_done(struct wlr_text_input_v3 *text_input);
#endif
